#!/bin/bash
set -e
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
DESKTOP_FILE="$HOME/.local/share/applications/qubes.desktop"

echo "=== Qubes Installation ==="
echo "Location: $SCRIPT_DIR"
echo ""

mkdir -p "$HOME/.local/share/applications"
cat > "$DESKTOP_FILE" << EOF
[Desktop Entry]
Name=Qubes
Comment=Sovereign AI Agents
Exec=$SCRIPT_DIR/launch.sh
Icon=$SCRIPT_DIR/resources/icon.png
Terminal=false
Type=Application
Categories=Utility;
StartupWMClass=qubes
EOF
echo "Desktop entry created: $DESKTOP_FILE"

read -p "Add 'qubes' command to PATH (~/.local/bin)? [y/N] " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  mkdir -p "$HOME/.local/bin"
  ln -sf "$SCRIPT_DIR/launch.sh" "$HOME/.local/bin/qubes"
  echo "Symlink: ~/.local/bin/qubes"
fi

echo ""
echo "Done! Launch from app menu or: $SCRIPT_DIR/launch.sh"
