#!/bin/bash
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

# Point HuggingFace to bundled models
if [ -d "$SCRIPT_DIR/models/huggingface" ]; then
  export HF_HOME="$SCRIPT_DIR/models/huggingface"
fi

# Point Ollama to bundled models
if [ -d "$SCRIPT_DIR/models/ollama" ]; then
  export OLLAMA_MODELS="$SCRIPT_DIR/models/ollama"
fi

# Add bundled CUDA/NVIDIA libraries to LD_LIBRARY_PATH
INTERNAL_DIR="$SCRIPT_DIR/qubes-backend/_internal"
if [ -d "$INTERNAL_DIR" ]; then
  NVIDIA_PATHS=$(find "$INTERNAL_DIR" -path "*/nvidia/*/lib" -type d 2>/dev/null | tr '\n' ':')
  if [ -n "$NVIDIA_PATHS" ]; then
    export LD_LIBRARY_PATH="${NVIDIA_PATHS}${LD_LIBRARY_PATH:+:$LD_LIBRARY_PATH}"
  fi
  export LD_LIBRARY_PATH="$INTERNAL_DIR${LD_LIBRARY_PATH:+:$LD_LIBRARY_PATH}"
fi

exec "$SCRIPT_DIR/Qubes" "$@"
