from libcpp.vector cimport vector

from ..typedefs cimport hash_t
from .kb cimport KnowledgeBase


# Object used by the Entity Linker that summarizes one entity-alias candidate
# combination.
cdef class Candidate:
    cdef readonly KnowledgeBase kb
    cdef hash_t entity_hash
    cdef float entity_freq
    cdef vector[float] entity_vector
    cdef hash_t alias_hash
    cdef float prior_prob
